﻿/**
 * @fileoverview 数据文件
 * @author sunnyjiang
 * @version 1.1
 */

/**
 * 常量
 */
var MAX_TAB_COUNT = 50;
var FAV_BAR_FOLDER_ICON = '../aero/images/favbar/FavBar_Folder.png';
var TAB_DEFAULT_ICON = '../aero/images/tab/QBrowserDefault.png';
var TAB_LOADING_ICON = '../aero/images/tab/loading/1.png';

// 是否激活新标签
var TAB_ACTIVE = 1;

var DEFAULT_SITE_TITLE = '首页';
var DEFAULT_SITE_URL = 'qqbrowser:home';
var BLANK_PAGE_URL = 'about:blank';
var FIRST_SITE_URL = '  ';

var MAX_TAB_COUNT = 100; // 最大标签数量

/**
 * 存储的tab菜单数据，可从此数据恢复tab
 */
var tabsData = [
    {url: '', title: 'about:blank'},
    {url: 'http://www.baidu.com', title: '百度哇哈哈哈我是测试适时实施'},
    {url: 'http://www.qq.com', title: '腾讯'},	
    {url: 'http://www.baidu.com', title: '百度'},
    {url: 'http://www.qq.com', title: '腾讯'},	
    {url: '', title: 'about:blank'},
    {url: 'http://www.baidu.com', title: '百度哇哈哈哈我是测试适时实施'},
    {url: 'http://www.qq.com', title: '腾讯'},	
    {url: 'http://www.baidu.com', title: '百度'},
    {url: 'http://www.qq.com', title: '腾讯'},
    {url: '', title: 'about:blank'},
    {url: 'http://www.baidu.com', title: '百度哇哈哈哈我是测试适时实施'},
    {url: 'http://www.qq.com', title: '腾讯'},	
    {url: 'http://www.baidu.com', title: '百度'},
    {url: 'http://www.qq.com', title: '腾讯'},
    {url: '', title: 'about:blank'},
    {url: 'http://www.baidu.com', title: '百度哇哈哈哈我是测试适时实施'},
    {url: 'http://www.qq.com', title: '腾讯'},	
    {url: 'http://www.baidu.com', title: '百度'},
    {url: 'http://www.qq.com', title: '腾讯'},    
    {url: 'http://www.baidu.com', title: '百度'}	
];

/**
 * 存储的收藏菜单数据
 */
var favsData = [
   {url: 'http://www.baidu.com', title: '公司', type: 'folder', id: 'fav1'},
   {url: '', title: '个人收藏收藏收藏收藏', type: 'folder', id: 'favi2'},
   {url: 'http://www.qq.com', title: '腾讯网', icon: '../aero/images/addressbar/www.soso.com_favicon.ico'},	
   {url: 'http://www.google.com', title: 'Google', icon: '../aero/images/addressbar/www.google.com_favicon.ico'},		
   {url: 'http://www.baidu.com', title: '百度嘟嘟嘟嘟嘟嘟嘟嘟嘟嘟的', icon: '../aero/images/addressbar/www.baidu.com_favicon.ico'},
   {url: 'qqbrowser:history', title: '历史记录', id: 'fav2'}, 
   {url: 'qqbrowser:home', title: '快速链接', id: 'fav3'}, 
   {url: 'qqbrowser:option', title: '选项', id: 'fav4'}, 
   {url: 'http://www.baidu.com', title: '公司', type: 'folder', id: 'fav1'},
   {url: '', title: '个人收藏收藏收藏收藏', type: 'folder', id: 'favi2'},
   {url: 'http://www.qq.com', title: '腾讯网', icon: '../aero/images/addressbar/www.soso.com_favicon.ico'},	
   {url: 'http://www.google.com', title: 'Google', icon: '../aero/images/addressbar/www.google.com_favicon.ico'},		
   {url: 'http://www.baidu.com', title: '百度嘟嘟嘟嘟嘟嘟嘟嘟嘟嘟的', icon: '../aero/images/addressbar/www.baidu.com_favicon.ico'},
   {url: 'qb:history', title: '历史记录', id: 'fav2'}, 
   {url: 'qb:home', title: '快速拨号', id: 'fav3'}, 
   {url: 'qb:config', title: '设置中心', id: 'fav4'}, 

];

/**
 * address list data
 * 
 */
var addressListData = [
	{url: 'http://hao.qq.com', title: 'QQ网址导航', type: 'history'},
	{url: 'http://www.baidu.com', title: '百度', type: 'auth'},
	{url: 'http://www.sina.com.cn', title: '新浪'},
    {url: 'http://www.qq.com', title: '腾讯首页'},	
];

/**
 * search engine list in address bar
 */
var addressListSearchListData = [
 	{url: 'http://www.soso.com', title: '搜搜', icon: '../default/images/addressbar/www.baidu.com_favicon.ico'},
	{url: 'http://www.baidu.com', title: '百度', icon: '../default/images/addressbar/www.google.com_favicon.ico'},
	{url: 'http://www.google.com.hk', title: '谷歌', icon: '../default/images/addressbar/www.soso.com_favicon.ico', selected: 1}
];

/**
 * 菜单选项数据，Menu根据此数据构造各菜单
 * selected: 选中与否，-1表示不可选择
 * func: 点击调用的方法
 * type: 类型，可以为分隔符，父菜单
 * status: -1为不可用
 * name: 对应到子菜单数据
 */
/**
 * 工具栏菜单数据
 */
var toolbarMenuData = [
    {selected: 1, value: '显示收藏栏', func: 'view.toggleFavbar()'},
    {selected: 1, value: '显示截屏按钮', func: "view.toggleButton('capture-button')"},
    {selected: 1, value: '显示清除浏览痕迹按钮', func: "view.toggleButton('clean-button')"}, 
];

/**
 * 标签栏菜单数据
 */
var tabMenuData = [
	{selected: -1, value: '新建标签页', func: 'tabManager.addTab()'},
	{selected: -1, value: '添加到收藏夹', func: 'test()'},
	{type: 'hr'},
	{selected: -1, value: '刷新', func: 'browser.page.reload()', status: -1}, 
	{type: 'hr'},
	{type: 'parent', selected: 0, value: '标签页自动分组', name: 'tabMenuGroup'}, 
	{type: 'hr'},
	{selected: -1, value: '关闭当前标签页', func: 'tabManager.closeSelectedTab()'}, 
	{selected: -1, value: '关闭其他标签页', func: 'tabManager.closeOtherTabs()'}, 
	{selected: -1, value: '关闭所有标签页', func: 'tabManager.closeAllTabs()'}, 	
];
var tabMenuGroupData = [
	{selected: -1, value: '始终分组', func: 'test()'},
	{selected: -1, value: '智能分组', func: 'test()'},
	{selected: 1, value: '从不分组', func: 'test()'}
];

/**
 * 收藏栏菜单数据
 */
var favbarMenuData = [
   	{selected: -1, value: '新建文件夹', func: 'test()'},
   	{type: 'hr'},
   	{selected: -1, value: '添加当前页到收藏夹', func: 'test()'},
   	{type: 'hr'},
    {selected: 1, value: '显示收藏栏', func: 'view.toggleFavbar()'}, // TODO 与toolbarMenuData显示值的逻辑
   	{type: 'hr'},
   	{selected: -1, value: '导入收藏夹', func: 'test()'},
   	{selected: -1, value: '导出收藏夹', func: 'test()'},   	
   	{type: 'hr'},
   	{selected: -1, value: '管理收藏夹', func: 'window.open(\'qqbrowser:favorite\')'}	
];

/**
 * 地址栏菜单数据
 */
var addressbarMenuData = [
 	{selected: -1, value: '粘贴并搜索', func: 'test()'},
 	{selected: -1, value: '复制标题和网址', func: 'test()', status: -1},
	{selected: -1, value: '撤销', func: 'test()', status: -1},
 	{type: 'hr'},
 	{selected: -1, value: '剪切', func: 'test()', status: -1},
 	{selected: -1, value: '复制', func: 'test()', status: -1}, 
 	{selected: -1, value: '粘贴', func: 'test()'}, 
 	{selected: -1, value: '删除', func: 'test()', status: -1},  	
 	{type: 'hr'},
 	{selected: -1, value: '全选', func: 'test()', status: -1}	
];

/**
 * 右上角主菜单数据
 */
var mainMenuData = [
	{type: 'parent', selected: 0, value: '文件', name: 'mainMenuFile'},
   	{type: 'parent', selected: 0, value: '查看', name: 'mainMenuView'},
  	{type: 'parent', selected: 0, value: '收藏', name: 'mainMenuFav'},
   	{type: 'parent', selected: 0, value: '工具', name: 'mainMenuTool'},
   	{type: 'parent', selected: 0, value: '帮助', name: 'mainMenuHelp'}, 	
];
var mainMenuFileData = [
	{selected: 0, value: '新建标签页(<span class="underline">T</span>)&nbsp;&nbsp;Ctrl + T'},
   	{selected: 0, value: '新建窗口'},
   	{selected: 0, value: '打开'},
   	{type: 'hr'},
  	{selected: 0, value: '另存为'},
   	{selected: 0, value: '打印'},
   	{type: 'hr'},
   	{selected: 0, value: '查找'}, 
];
var mainMenuViewData = [
	{type: 'parent', selected: 0, value: '编码(<span class="underline">D</span>)', name: 'mainMenuViewCharset'},
   	{selected: 0, value: '查看源码(<span class="underline">C</span>)'}
];
var mainMenuFavData = [
	{selected: 0, value: '显示收藏栏', func: 'view.toggleFavbar()'},
   	{selected: 0, value: '添加到收藏夹'},
   	{selected: 0, value: '导入收藏夹'},
  	{selected: 0, value: '导出收藏夹'},
   	{selected: 0, value: '管理收藏夹'},
];
var mainMenuToolData = [
	{selected: 1, value: '使用IE代理'},
  	{selected: 0, value: '截屏'},
  	{selected: 0, value: '历史记录'},
 	{selected: 0, value: '清除历史痕迹'},
  	{selected: 0, value: '选项(<span class="underline">C</span>)...'},
];
var mainMenuHelpData = [
	{selected: 0, value: '反馈建议(<span class="underline">J</span>)'},
 	{selected: 0, value: '功能演示(<span class="underline">G</span>)'},
 	{selected: 0, value: '官方网站(<span class="underline">W</span>)'},
	{selected: 0, value: '关于(<span class="underline">A</span>)'}
];
var mainMenuViewCharsetData = [
	{selected: 0, value: '中文简体(GBK)'},
 	{selected: 0, value: '中文简体(gb 18030)'},
 	{selected: 0, value: '中文繁体(Big5)'},
	{selected: 0, value: '中文繁体(Big5-HKSCS)'},
   	{type: 'hr'},
	{selected: 1, value: 'Unicode(UTF-8)'},
	{selected: 0, value: '西欧语言(ISO)'},
	{selected: 0, value: '西欧语言(windows)'},
   	{type: 'hr'},
	{selected: 0, value: '日语(Shift_JIS)'},
	{selected: 0, value: '日语(ISO-2022-JP)'},
	{selected: 0, value: '日语(EUC-JP)'},
	{selected: 0, value: '韩语(windows-949)'},
	{selected: 0, value: '泰语(windows-874)'},
	{selected: 0, value: '越南语(ISO-8859-14)'},
];

/**
 * 常用菜单数据
 */
var usefulMenuData = [
    {selected: -1, value: '切换皮肤', func: 'view.toggleSkin()'},                    
	{selected: 0, value: '新建标签页'},
   	{selected: 0, value: '新建窗口'},
  	{selected: 0, value: '另存为'},
   	{selected: 0, value: '查找'},
   	{type: 'hr'},
   	{type: 'parent', selected: 0, value: '收藏', name: 'usefulMenuFav'}, 	
   	{selected: 0, value: '使用IE代理'},
   	{selected: 0, value: '历史记录&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Ctrl + H'},
   	{selected: 0, value: '清除浏览痕迹'},	
   	{type: 'hr'},
   	{selected: 0, value: '选项'}	
];
var usefulMenuFavData = [
	{selected: 1, value: '显示收藏栏', func: 'view.toggleFavbar()'},
	{selected: 0, value: '添加到收藏夹'},
	{selected: 0, value: '导入收藏夹'},
	{selected: 0, value: '导出收藏夹'},
	{selected: 0, value: '管理收藏夹'},
];

/**
 * logo登录动画
 */
var logoBigAnimateList = ['images/logomenu/logoAnimate/Big/logoAnimateBig_1.png' , 
	'images/logomenu/logoAnimate/Big/logoAnimateBig_2.png' , 'images/logomenu/logoAnimate/Big/logoAnimateBig_3.png' , 
	'images/logomenu/logoAnimate/Big/logoAnimateBig_4.png' , 'images/logomenu/logoAnimate/Big/logoAnimateBig_5.png' ,
	'images/logomenu/logoAnimate/Big/logoAnimateBig_6.png' , 'images/logomenu/logoAnimate/Big/logoAnimateBig_7.png' , 
	'images/logomenu/logoAnimate/Big/logoAnimateBig_8.png' , 'images/logomenu/logoAnimate/Big/logoAnimateBig_9.png' ,
	'images/logomenu/logoAnimate/Big/logoAnimateBig_10.png' , 'images/logomenu/logoAnimate/Big/logoAnimateBig_11.png' , 
	'images/logomenu/logoAnimate/Big/logoAnimateBig_12.png' , 'images/logomenu/logoAnimate/Big/logoAnimateBig_13.png' ,
	'images/logomenu/logoAnimate/Big/logoAnimateBig_14.png' , 'images/logomenu/logoAnimate/Big/logoAnimateBig_15.png' ,
	'images/logomenu/logoAnimate/Big/logoAnimateBig_16.png' , 'images/logomenu/logoAnimate/Big/logoAnimateBig_17.png' , 
	'images/logomenu/logoAnimate/Big/logoAnimateBig_18.png'];
var logoSmallAnimateList = ['images/logomenu/logoAnimate/Small/logoAnimateSmall_1.png' , 
	'images/logomenu/logoAnimate/Small/logoAnimateSmall_2.png' , 'images/logomenu/logoAnimate/Small/logoAnimateSmall_3.png' , 
	'images/logomenu/logoAnimate/Small/logoAnimateSmall_4.png' , 'images/logomenu/logoAnimate/Small/logoAnimateSmall_5.png' ,
	'images/logomenu/logoAnimate/Small/logoAnimateSmall_6.png' , 'images/logomenu/logoAnimate/Small/logoAnimateSmall_7.png' , 
	'images/logomenu/logoAnimate/Small/logoAnimateSmall_8.png' , 'images/logomenu/logoAnimate/Small/logoAnimateSmall_9.png' ,
	'images/logomenu/logoAnimate/Small/logoAnimateSmall_10.png' , 'images/logomenu/logoAnimate/Small/logoAnimateSmallg_11.png' , 
	'images/logomenu/logoAnimate/Small/logoAnimateSmall_12.png' , 'images/logomenu/logoAnimate/Small/logoAnimateSmall_13.png' ,
	'images/logomenu/logoAnimate/Small/logoAnimateSmall_14.png' , 'images/logomenu/logoAnimate/Small/logoAnimateSmall_15.png' ,
	'images/logomenu/logoAnimate/Small/logoAnimateSmall_16.png' , 'images/logomenu/logoAnimate/Small/logoAnimateSmall_17.png' , 
	'images/logomenu/logoAnimate/Small/logoAnimateSmall_18.png'];

// tab loading animate
var tabLoadingAnimateList = ['images/tab/loading/1.png' , 
	'images/tab/loading/2.png' , 'images/tab/loading/3.png' , 
	'images/tab/loading/4.png' , 'images/tab/loading/5.png' ,
	'images/tab/loading/6.png' , 'images/tab/loading/7.png' , 
	'images/tab/loading/8.png' , 'images/tab/loading/9.png' ,
	'images/tab/loading/10.png' , 'images/tab/loading/11.png'];
